<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Help-Settings-Schema"
                              xmlns:wwhsettings="urn:WebWorks-Help-Settings-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterWWHelpEntrySplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />
 <xsl:param name="ParameterMergeCategory" />
 <xsl:param name="ParameterMergeUse" />
 <xsl:param name="ParameterMergeDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwhsettings" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:variable name="GlobalEntryTemplatePath" select="wwuri:AsFilePath('wwformat:Transforms/wwhelp_entry.html')" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarIgnore1Start" select="wwprogress:Start(count($VarProjectGroups) + 1)" />

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarIgnore2Start" select="wwprogress:Start(1)" />

    <!-- Load splits -->
    <!--             -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))[1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <!-- Get entry path -->
     <!--                -->
     <xsl:for-each select="$VarSplits[1]">
      <xsl:variable name="VarEntryFile" select="key('wwsplits-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterWWHelpEntrySplitFileType))[1]" />

      <!-- Set entry -->
      <!--           -->
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarEntryFile/@path, $VarProjectGroup/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <!-- Copy -->
       <!--      -->
       <xsl:variable name="VarIgnore3" select="wwfilesystem:CopyFile($GlobalEntryTemplatePath, $VarEntryFile/@path)" />
      </xsl:if>

      <!-- Report Files -->
      <!--              -->
      <wwfiles:File path="{$VarEntryFile/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarEntryFile/@path)}" projectchecksum="{$VarProjectGroup/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
       <wwfiles:Depends path="{$GlobalEntryTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalEntryTemplatePath)}" groupID="" documentID="" />
      </wwfiles:File>

     </xsl:for-each>
    </xsl:for-each>

    <xsl:variable name="VarIgnore2End" select="wwprogress:End()" />
   </xsl:for-each>

   <!-- Merge -->
   <!--       -->
   <xsl:if test="count($VarProjectGroups) &gt; 1">
    <xsl:variable name="VarEntryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetFormatSetting('wwhelp-entry', 'index.html'))" />

    <!-- Set entry -->
    <!--           -->
    <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarEntryPath, $GlobalProject/wwproject:Project/@ChangeID, '', '', $GlobalActionChecksum)" />
    <xsl:if test="not($VarUpToDate)">
     <!-- Copy -->
     <!--      -->
     <xsl:variable name="VarIgnore4" select="wwfilesystem:CopyFile($GlobalEntryTemplatePath, $VarEntryPath)" />
    </xsl:if>

    <!-- Report Files -->
    <!--              -->
    <wwfiles:File path="{$VarEntryPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarEntryPath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterMergeCategory}" use="{$ParameterMergeUse}" deploy="{$ParameterMergeDeploy}">
     <wwfiles:Depends path="{$GlobalEntryTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalEntryTemplatePath)}" groupID="" documentID="" />
    </wwfiles:File>
   </xsl:if>

   <xsl:variable name="VarIgnore1End" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>
</xsl:stylesheet>
